const swaggerJsDoc = require('swagger-jsdoc');

const swaggerDefinition = {
  openapi: '3.0.0',
  info: {
    title: 'API Documentation',
    version: '1.0.0',
    description: 'API documentation prepared for the Express project',
  },
  servers: [
    {
      //url: "https://ktkoptika-api.webluna.org/"
      url: 'http://localhost:3001',
    },
  ],
  components: {
    securitySchemes: {
      customAuth: {
        type: 'apiKey',
        in: 'header',
        name: 'ktkoptika-auth-token',
        description: 'Login token, Bearer olmadan',
      },
      apiKeyAuth: {
        type: 'apiKey',
        in: 'header',
        name: 'ktkoptika-access',
        description: 'Statik API açarı',
      },
    },
  },
  security: [
    {
      customAuth: [],
    },
    {
      apiKeyAuth: [],
    },
  ],
};

const options = {
  swaggerDefinition,
  apis: ['./swagger/docs**/*.js', './swagger/docs/product**/*.js'],
};

const swaggerDocs = swaggerJsDoc(options);

module.exports = swaggerDocs;
