/**
 * @swagger
 * tags:
 *   name: Wishlist
 *   description: Wishlist management API
 */

/**
 * @swagger
 * components:
 *   schemas:
 *     Wishlist:
 *       type: object
 *       properties:
 *         user:
 *           type: string
 *           description: User ID (MongoDB ObjectId)
 *         products:
 *           type: array
 *           items:
 *             type: string
 *           description: List of Product IDs
 *         createdAt:
 *           type: string
 *           format: date-time
 *         updatedAt:
 *           type: string
 *           format: date-time
 *       example:
 *         user: "64f123456789abcdef012345"
 *         products: ["64fabc456789abcdef012341", "64fabc456789abcdef012342"]
 *         createdAt: "2024-07-01T10:30:00.000Z"
 *         updatedAt: "2024-07-02T08:15:00.000Z"
 */

/**
 * @swagger
 * /api/v1/wishlist/{user}:
 *   get:
 *     summary: Get wishlist by user ID
 *     tags: [Wishlist]
 *     parameters:
 *       - in: path
 *         name: user
 *         required: true
 *         schema:
 *           type: string
 *         description: User ID
 *     responses:
 *       200:
 *         description: Wishlist retrieved successfully
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Wishlist'
 *       404:
 *         description: Wishlist not found
 *       500:
 *         description: Server error
 *
 *
 *   put:
 *     summary: Update wishlist for user
 *     tags: [Wishlist]
 *     parameters:
 *       - in: path
 *         name: user
 *         required: true
 *         schema:
 *           type: string
 *         description: User ID
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             type: object
 *             properties:
 *               products:
 *                 type: array
 *                 items:
 *                   type: string
 *             required:
 *               - products
 *             example:
 *               products: ["64fabc456789abcdef012348", "64fabc456789abcdef012349"]
 *     responses:
 *       200:
 *         description: Wishlist updated successfully
 *       400:
 *         description: Bad request
 *       404:
 *         description: Wishlist not found
 *       500:
 *         description: Server error
 */

