
/**
 * @swagger
 * tags:
 *   name: Slider
 *   description: Slider management API
 */

/**
 * @swagger
 * components:
 *   schemas:
 *     Slider:
 *       type: object
 *       properties:
 *         image:
 *           type: string
 *           description: Image URL or path
 *         titleAz:
 *           type: string
 *           description: Title in Azerbaijani
 *         titleEn:
 *           type: string
 *           description: Title in English
 *         titleRu:
 *           type: string
 *           description: Title in Russian
 *         textAz:
 *           type: string
 *           description: Text in Azerbaijani
 *         textEn:
 *           type: string
 *           description: Text in English
 *         textRu:
 *           type: string
 *           description: Text in Russian
 *         btnUrl:
 *           type: string
 *           description: Button URL
 *       example:
 *         row: 1
 *         slug: "main-banner"
 *         image: "https://example.com/images/banner1.jpg"
 *         titleAz: "Əsas Banner"
 *         titleEn: "Main Banner"
 *         titleRu: "Главный баннер"
 *         textAz: "Əsas slider üçün mətn"
 *         textEn: "Text for main slider"
 *         textRu: "Текст для главного слайдера"
 *         btnUrl: "https://example.com/shop"
 */

/**
 * @swagger
 * /api/v1/ad/slider:
 *   post:
 *     summary: Add new slider
 *     tags: [Slider]
 *     requestBody:
 *       required: true
 *       content:
 *         multipart/form-data:
 *           schema:
 *             type: object
 *             properties:
 *               image:
 *                 type: string
 *                 format: binary
 *               titleAz:
 *                 type: string
 *               titleEn:
 *                 type: string
 *               titleRu:
 *                 type: string
 *               textAz:
 *                 type: string
 *               textEn:
 *                 type: string
 *               textRu:
 *                 type: string
 *               btnUrl:
 *                 type: string
 *             required:
 *               - slug
 *               - image
 *     responses:
 *       201:
 *         description: Slider created successfully
 *       400:
 *         description: Bad request
 *       500:
 *         description: Server error
 *
 * /api/v1/ad/slider/{id}:
 *   put:
 *     summary: Update slider by ID
 *     tags: [Slider]
 *     parameters:
 *       - in: path
 *         name: id
 *         required: true
 *         schema:
 *           type: string
 *         description: Slider ID
 *     requestBody:
 *       required: false
 *       content:
 *         multipart/form-data:
 *           schema:
 *             type: object
 *             properties:
 *               image:
 *                 type: string
 *                 format: binary
 *               titleAz:
 *                 type: string
 *               titleEn:
 *                 type: string
 *               titleRu:
 *                 type: string
 *               textAz:
 *                 type: string
 *               textEn:
 *                 type: string
 *               textRu:
 *                 type: string
 *               btnUrl:
 *                 type: string
 *     responses:
 *       200:
 *         description: Slider updated successfully
 *       400:
 *         description: Bad request
 *       404:
 *         description: Slider not found
 *       500:
 *         description: Server error
 *
 *   delete:
 *     summary: Delete slider by ID
 *     tags: [Slider]
 *     parameters:
 *       - in: path
 *         name: id
 *         required: true
 *         schema:
 *           type: string
 *         description: Slider ID
 *     responses:
 *       200:
 *         description: Slider deleted successfully
 *       404:
 *         description: Slider not found
 *       500:
 *         description: Server error
 *
 * /api/v1/slider:
 *   get:
 *     summary: Get list of sliders
 *     tags: [Slider]
 *     responses:
 *       200:
 *         description: List of sliders
 *         content:
 *           application/json:
 *             schema:
 *               type: array
 *               items:
 *                 $ref: '#/components/schemas/Slider'
 *       500:
 *         description: Server error
 */
