
/**
 * @swagger
 * components:
 *   schemas:
 *     ProductBase:
 *       type: object
 *       properties:
 *         images:
 *           type: array
 *           items:
 *             type: string
 *             format: binary
 *           description: Şəkillər
 *         thumbnail:
 *           type: array
 *           items:
 *             type: string
 *             format: binary
 *           description: Thumbnail-lar
 *         titleAz:
 *           type: string
 *           description: Başlıq Az
 *         titleEn:
 *           type: string
 *           description: Başlıq En
 *         titleRu:
 *           type: string
 *           description: Başlıq Ru
 *         price:
 *           type: number
 *           description: Qiymət
 *         discountPrice:
 *           type: number
 *           description: Endirimli qiymət
 *         textAz:
 *           type: string
 *           description: Təsvir Az
 *         textEn:
 *           type: string
 *           description: Təsvir En
 *         textRu:
 *           type: string
 *           description: Təsvir Ru
 *         category:
 *           type: string
 *           description: Kateqoriya slug
 *         color:
 *           type: string
 *           description: Rəng slug
 *         brand:
 *           type: string
 *           description: Marka slug
 *         campaign:
 *           type: string
 *           description: Kampaniya slug
 *         gender:
 *           type: string
 *           enum: [male, female, uni, boy, girl]
 *           description: Gender
 *         recommended:
 *           type: boolean
 *           description: Tövsiyə olunan
 *         bestSeller:
 *           type: boolean
 *           description: Ən çox satılan
 *         stock:
 *           type: number
 *           description: Stok sayı
 *     ProductGet:
 *       allOf:
 *         - $ref: '#/components/schemas/ProductBase'
 *     ProductPostPut:
 *       allOf:
 *         - $ref: '#/components/schemas/ProductBase'
 *         - type: object
 *           properties:
 *             slug:
 *               type: string
 *               description: Slug (yaradılarkən əlavə olunur)
 *             productID:
 *               type: string
 *               description: Unikal məhsul ID-si
 */

/**
 * @swagger
 * /api/v1/product/{slug}:
 *   get:
 *     summary: Slug-a əsasən məhsul tap
 *     tags: [Product]
 *     parameters:
 *       - in: path
 *         name: slug
 *         required: true
 *         schema:
 *           type: string
 *         description: Məhsulun slug dəyəri
 *     responses:
 *       202:
 *         description: Məhsul tapıldı
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/ProductGet'
 *       406:
 *         description: Məhsul tapılmadı
 *       502:
 *         description: Server xətası
 */

/**
 * @swagger
 * /api/v1/product:
 *   get:
 *     summary: Məhsulların siyahısı, filter və sort ilə
 *     tags: [Product]
 *     parameters:
 *       - in: query
 *         name: category
 *         schema:
 *           type: string
 *         description: Kateqoriya slug üzrə filter
 *       - in: query
 *         name: brand
 *         schema:
 *           type: string
 *         description: Marka slug üzrə filter
 *       - in: query
 *         name: color
 *         schema:
 *           type: string
 *         description: Rəng slug üzrə filter
 *       - in: query
 *         name: gender
 *         schema:
 *           type: string
 *           enum: [male, female, uni, boy, girl]
 *         description: Gender filter
 *       - in: query
 *         name: recommended
 *         schema:
 *           type: boolean
 *         description: Tövsiyə olunan məhsullar (true/false)
 *       - in: query
 *         name: bestSeller
 *         schema:
 *           type: boolean
 *         description: Ən çox satılan məhsullar (true/false)
 *       - in: query
 *         name: stock
 *         schema:
 *           type: integer
 *         description: |
 *           Stok filtr:
 *             - `0` → yalnız stok = 0 olan məhsullar
 *             - `N` (məsələn, `3`) → yalnız stok > N olan məhsullar
 *       - in: query
 *         name: campaign
 *         schema:
 *           type: string
 *         description: Kampaniya slug üzrə filter
 *       - in: query
 *         name: sortBy
 *         schema:
 *           type: string
 *           enum: [titleAz, price]
 *         description: Sıralama sahəsi
 *       - in: query
 *         name: order
 *         schema:
 *           type: string
 *           enum: [asc, desc]
 *         description: Sıralama istiqaməti
 *     responses:
 *       202:
 *         description: Məhsulların siyahısı
 *         content:
 *           application/json:
 *             schema:
 *               type: array
 *               items:
 *                 $ref: '#/components/schemas/ProductGet'
 *       502:
 *         description: Server xətası
 */

/**
 * @swagger
 * /api/v1/ad/product:
 *   post:
 *     summary: Yeni məhsul əlavə et
 *     tags: [Product]
 *     requestBody:
 *       required: true
 *       content:
 *         multipart/form-data:
 *           schema:
 *             $ref: '#/components/schemas/ProductPostPut'
 *     responses:
 *       203:
 *         description: Məhsul yaradıldı
 *       402:
 *         description: Yanlış sorğu
 *       502:
 *         description: Server xətası
 */

/**
 * @swagger
 * /api/v1/ad/product/{id}:
 *   put:
 *     summary: Məhsulu yenilə
 *     tags: [Product]
 *     parameters:
 *       - in: path
 *         name: id
 *         required: true
 *         schema:
 *           type: string
 *         description: Məhsulun ID-si
 *     requestBody:
 *       required: true
 *       content:
 *         multipart/form-data:
 *           schema:
 *             $ref: '#/components/schemas/ProductPostPut'
 *     responses:
 *       202:
 *         description: Məhsul yeniləndi
 *       402:
 *         description: Yanlış sorğu
 *       406:
 *         description: Məhsul tapılmadı
 *       502:
 *         description: Server xətası
 */

/**
 * @swagger
 * /api/v1/ad/product/{id}:
 *   delete:
 *     summary: Məhsulu sil
 *     tags: [Product]
 *     parameters:
 *       - in: path
 *         name: id
 *         required: true
 *         schema:
 *           type: string
 *         description: Məhsulun ID-si
 *     responses:
 *       205:
 *         description: Məhsul silindi
 *       405:
 *         description: Məhsul tapılmadı
 *       501:
 *         description: Server xətası
 */
