
/**
 * @swagger
 * tags:
 *   name: Color
 *   description: Color management API
 */

/**
 * @swagger
 * components:
 *   schemas:
 *     Color:
 *       type: object
 *       properties:
 *         row:
 *           type: integer
 *           description: Display order of the color
 *         slug:
 *           type: string
 *           description: Unique slug for the color
 *         titleAz:
 *           type: string
 *           description: Title in Azerbaijani
 *         titleEn:
 *           type: string
 *           description: Title in English
 *         titleRu:
 *           type: string
 *           description: Title in Russian
 *         colorCode:
 *           type: string
 *           description: HEX or RGB color code
 *       example:
 *         row: 1
 *         slug: "red"
 *         titleAz: "Qırmızı"
 *         titleEn: "Red"
 *         titleRu: "Красный"
 *         colorCode: "#FF0000"
 */

/**
 * @swagger
 * /api/v1/ad/color:
 *   post:
 *     summary: Add new color
 *     tags: [Color]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/Color'
 *     responses:
 *       201:
 *         description: Color created successfully
 *       400:
 *         description: Bad request
 *       500:
 *         description: Server error
 *
 * /api/v1/ad/color/{id}:
 *   put:
 *     summary: Update color by ID
 *     tags: [Color]
 *     parameters:
 *       - in: path
 *         name: id
 *         required: true
 *         schema:
 *           type: string
 *         description: Color ID
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/Color'
 *     responses:
 *       200:
 *         description: Color updated successfully
 *       400:
 *         description: Bad request
 *       404:
 *         description: Color not found
 *       500:
 *         description: Server error
 *
 *   delete:
 *     summary: Delete color by ID
 *     tags: [Color]
 *     parameters:
 *       - in: path
 *         name: id
 *         required: true
 *         schema:
 *           type: string
 *         description: Color ID
 *     responses:
 *       200:
 *         description: Color deleted successfully
 *       404:
 *         description: Color not found
 *       500:
 *         description: Server error
 *
 * /api/v1/color:
 *   get:
 *     summary: Get list of colors
 *     tags: [Color]
 *     responses:
 *       200:
 *         description: List of colors
 *         content:
 *           application/json:
 *             schema:
 *               type: array
 *               items:
 *                 $ref: '#/components/schemas/Color'
 *       500:
 *         description: Server error
 */
