
/**
 * @swagger
 * tags:
 *   name: Category
 *   description: Kateqoriya idarəetməsi
 */

/**
 * @swagger
 * components:
 *   schemas:
 *     CategoryBase:
 *       type: object
 *       properties:
 *         row:
 *           type: integer
 *           description: Sıra nömrəsi
 *         slug:
 *           type: string
 *           description: URL dostu unikal ad (slug)
 *         image:
 *           type: string
 *           format: binary
 *           description: Şəkil faylı (JPG, PNG və s.)
 *         titleAz:
 *           type: string
 *           description: Başlıq (Azərbaycanca)
 *         titleEn:
 *           type: string
 *           description: Başlıq (İngiliscə)
 *         titleRu:
 *           type: string
 *           description: Başlıq (Rusca)
 *         textAz:
 *           type: string
 *           description: Mətn (Azərbaycanca)
 *         textEn:
 *           type: string
 *           description: Mətn (İngiliscə)
 *         textRu:
 *           type: string
 *           description: Mətn (Rusca)
 *         homePageShow:
 *           type: boolean
 *           default: false
 *           description: Əsas səhifədə göstərilsin?
 *       required:
 *         - titleAz
 *         - titleEn
 *         - titleRu
 */

/**
 * @swagger
 * /api/v1/category:
 *   get:
 *     summary: Bütün kateqoriyaları siyahıla
 *     tags: [Category]
 *     responses:
 *       200:
 *         description: Kateqoriyaların siyahısı
 *         content:
 *           application/json:
 *             schema:
 *               type: array
 *               items:
 *                 $ref: '#/components/schemas/CategoryBase'
 *       500:
 *         description: Server xətası
 */

/**
 * @swagger
 * /api/v1/ad/category:
 *   post:
 *     summary: Yeni kateqoriya əlavə et
 *     tags: [Category]
 *     requestBody:
 *       required: true
 *       content:
 *         multipart/form-data:
 *           schema:
 *             $ref: '#/components/schemas/CategoryBase'
 *     responses:
 *       201:
 *         description: Kateqoriya yaradıldı
 *       400:
 *         description: Yanlış sorğu
 *       500:
 *         description: Server xətası
 */

/**
 * @swagger
 * /api/v1/ad/category/{id}:
 *   put:
 *     summary: Kateqoriyanı yenilə
 *     tags: [Category]
 *     parameters:
 *       - in: path
 *         name: id
 *         required: true
 *         schema:
 *           type: string
 *         description: Kateqoriyanın ID-si
 *     requestBody:
 *       required: true
 *       content:
 *         multipart/form-data:
 *           schema:
 *             $ref: '#/components/schemas/CategoryBase'
 *     responses:
 *       200:
 *         description: Yeniləndi
 *       400:
 *         description: Yanlış sorğu
 *       404:
 *         description: Tapılmadı
 *       500:
 *         description: Server xətası
 *
 *   delete:
 *     summary: Kateqoriyanı sil
 *     tags: [Category]
 *     parameters:
 *       - in: path
 *         name: id
 *         required: true
 *         schema:
 *           type: string
 *         description: Kateqoriyanın ID-si
 *     responses:
 *       200:
 *         description: Uğurla silindi
 *       404:
 *         description: Tapılmadı
 *       500:
 *         description: Server xətası
 */
