/**
 * @swagger
 * tags:
 *   name: Brand
 *   description: Brand management API
 */

/**
 * @swagger
 * components:
 *   schemas:
 *     Brand:
 *       type: object
 *       properties:
 *         titleAz:
 *           type: string
 *           description: Title in Azerbaijani
 *         titleEn:
 *           type: string
 *           description: Title in English
 *         titleRu:
 *           type: string
 *           description: Title in Russian
 *       example:
 *         row: 1
 *         slug: "nike"
 *         titleAz: "Nike"
 *         titleEn: "Nike"
 *         titleRu: "Найк"
 */

/**
 * @swagger
 * /api/v1/ad/brand:
 *   post:
 *     summary: Add new brand
 *     tags: [Brand]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/Brand'
 *     responses:
 *       201:
 *         description: Brand created successfully
 *       400:
 *         description: Bad request
 *       500:
 *         description: Server error
 *
 * /api/v1/ad/brand/{id}:
 *   put:
 *     summary: Update brand by ID
 *     tags: [Brand]
 *     parameters:
 *       - in: path
 *         name: id
 *         required: true
 *         schema:
 *           type: string
 *         description: Brand ID
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/Brand'
 *     responses:
 *       200:
 *         description: Brand updated successfully
 *       400:
 *         description: Bad request
 *       404:
 *         description: Brand not found
 *       500:
 *         description: Server error
 *
 *   delete:
 *     summary: Delete brand by ID
 *     tags: [Brand]
 *     parameters:
 *       - in: path
 *         name: id
 *         required: true
 *         schema:
 *           type: string
 *         description: Brand ID
 *     responses:
 *       200:
 *         description: Brand deleted successfully
 *       404:
 *         description: Brand not found
 *       500:
 *         description: Server error
 *
 * /api/v1/brand:
 *   get:
 *     summary: Get list of brands
 *     tags: [Brand]
 *     responses:
 *       200:
 *         description: List of brands
 *         content:
 *           application/json:
 *             schema:
 *               type: array
 *               items:
 *                 $ref: '#/components/schemas/Brand'
 *       500:
 *         description: Server error
 */
