
/**
 * @swagger
 * tags:
 *   name: GeneralInfo
 *   description: General information management API
 */

/**
 * @swagger
 * components:
 *   schemas:
 *     GeneralInfo:
 *       type: object
 *       properties:
 *         phoneNumber:
 *           type: string
 *           description: Contact phone number
 *         email:
 *           type: string
 *           format: email
 *           description: Contact email address
 *         addressAz:
 *           type: string
 *           description: Address in Azerbaijani
 *         addressEn:
 *           type: string
 *           description: Address in English
 *         addressRu:
 *           type: string
 *           description: Address in Russian
 *         whatsappUrl:
 *           type: string
 *           description: WhatsApp contact URL
 *         fbUrl:
 *           type: string
 *           description: Facebook profile URL
 *         instagramUrl:
 *           type: string
 *           description: Instagram profile URL
 *         youtubeUrl:
 *           type: string
 *           description: YouTube channel URL
 *         linkedinUrl:
 *           type: string
 *           description: LinkedIn profile URL
 *         tiktokUrl:
 *           type: string
 *           description: TikTok profile URL
 *         twitterUrl:
 *           type: string
 *           description: Twitter profile URL
 *       example:
 *         phoneNumber: "+994 50 123 45 67"
 *         email: "info@example.com"
 *         addressAz: "Bakı, Azərbaycan"
 *         addressEn: "Baku, Azerbaijan"
 *         addressRu: "Баку, Азербайджан"
 *         whatsappUrl: "https://wa.me/994501234567"
 *         fbUrl: "https://facebook.com/example"
 *         instagramUrl: "https://instagram.com/example"
 *         youtubeUrl: "https://youtube.com/example"
 *         linkedinUrl: "https://linkedin.com/example"
 *         tiktokUrl: "https://tiktok.com/@example"
 *         twitterUrl: "https://twitter.com/example"
 */

/**
 * @swagger
 * /api/v1/ad/generalinfo:

 *   put:
 *     summary: Update general information
 *     tags: [GeneralInfo]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/GeneralInfo'
 *     responses:
 *       200:
 *         description: General information updated successfully
 *       400:
 *         description: Bad request
 *       500:
 *         description: Server error
 *
 */





/**
 * @swagger
 * /api/v1/generalinfo:
 *   get:
 *     summary: Get general information
 *     tags: [GeneralInfo]
 *     responses:
 *       200:
 *         description: Successfully fetched general information
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/GeneralInfo'
 *       404:
 *         description: General information not found
 *       500:
 *         description: Server error
 */






/**
 * @swagger
 * /api/v1/search:
 *   get:
 *     summary: Bütün kolleksiyalarda axtarış et
 *     description: Verilən `searchTerm` əsasında MongoDB-dəki bütün kolleksiyalarda `titleAz`, `titleEn` və `titleRu` sahələrində axtarış edir.
 *     parameters:
 *       - in: query
 *         name: searchTerm
 *         required: true
 *         schema:
 *           type: string
 *         description: Axtarılacaq söz və ya ifadə
 *       - in: query
 *         name: page
 *         schema:
 *           type: integer
 *           default: 1
 *         description: Səhifə nömrəsi
 *       - in: query
 *         name: limit
 *         schema:
 *           type: integer
 *           default: 10
 *         description: Nəticə limit sayı
 *     responses:
 *       200:
 *         description: Axtarış nəticələri
 *         content:
 *           application/json:
 *             schema:
 *               type: object
 *               additionalProperties:
 *                 type: array
 *                 items:
 *                   type: object
 *       400:
 *         description: Axtarış sözü daxil edilməyib
 *       500:
 *         description: Server xətası
 */








