
/**
 * @swagger
 * tags:
 *   name: Campaign
 *   description: Campaign management API
 */

/**
 * @swagger
 * components:
 *   schemas:
 *     Campaign:
 *       type: object
 *       properties:
 *         row:
 *           type: integer
 *           description: Display order of the campaign
 *         slug:
 *           type: string
 *           description: Unique slug for the campaign
 *         image:
 *           type: string
 *           description: Image URL or path
 *         titleAz:
 *           type: string
 *           description: Title in Azerbaijani
 *         titleEn:
 *           type: string
 *           description: Title in English
 *         titleRu:
 *           type: string
 *           description: Title in Russian
 *         textAz:
 *           type: string
 *           description: Text in Azerbaijani
 *         textEn:
 *           type: string
 *           description: Text in English
 *         textRu:
 *           type: string
 *           description: Text in Russian
 *         startDate:
 *           type: string
 *           format: date
 *           description: Campaign start date
 *         endDate:
 *           type: string
 *           format: date
 *           description: Campaign end date
 *       example:
 *         row: 1
 *         slug: "summer-sale"
 *         image: "https://example.com/images/summer-sale.jpg"
 *         titleAz: "Yay Endirimi"
 *         titleEn: "Summer Sale"
 *         titleRu: "Летняя распродажа"
 *         textAz: "Yay mövsümünə özəl endirimlər."
 *         textEn: "Special discounts for summer season."
 *         textRu: "Специальные скидки на летний сезон."
 *         startDate: "2025-06-01"
 *         endDate: "2025-08-31"
 */

/**
 * @swagger
 * /api/v1/ad/campaign:
 *   post:
 *     summary: Add new campaign
 *     tags: [Campaign]
 *     requestBody:
 *       required: true
 *       content:
 *         multipart/form-data:
 *           schema:
 *             type: object
 *             properties:
 *               row:
 *                 type: integer
 *               slug:
 *                 type: string
 *               image:
 *                 type: string
 *                 format: binary
 *               titleAz:
 *                 type: string
 *               titleEn:
 *                 type: string
 *               titleRu:
 *                 type: string
 *               textAz:
 *                 type: string
 *               textEn:
 *                 type: string
 *               textRu:
 *                 type: string
 *               startDate:
 *                 type: string
 *                 format: date
 *               endDate:
 *                 type: string
 *                 format: date
 *             required:
 *               - slug
 *               - image
 *     responses:
 *       201:
 *         description: Campaign created successfully
 *       400:
 *         description: Bad request
 *       500:
 *         description: Server error
 *
 * /api/v1/ad/campaign/{id}:
 *   put:
 *     summary: Update campaign by ID
 *     tags: [Campaign]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: string
 *         required: true
 *         description: Campaign ID
 *     requestBody:
 *       required: false
 *       content:
 *         multipart/form-data:
 *           schema:
 *             type: object
 *             properties:
 *               row:
 *                 type: integer
 *               slug:
 *                 type: string
 *               image:
 *                 type: string
 *                 format: binary
 *               titleAz:
 *                 type: string
 *               titleEn:
 *                 type: string
 *               titleRu:
 *                 type: string
 *               textAz:
 *                 type: string
 *               textEn:
 *                 type: string
 *               textRu:
 *                 type: string
 *               startDate:
 *                 type: string
 *                 format: date
 *               endDate:
 *                 type: string
 *                 format: date
 *     responses:
 *       200:
 *         description: Campaign updated successfully
 *       400:
 *         description: Bad request
 *       404:
 *         description: Campaign not found
 *       500:
 *         description: Server error
 *
 *   delete:
 *     summary: Delete campaign by ID
 *     tags: [Campaign]
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: string
 *         required: true
 *         description: Campaign ID
 *     responses:
 *       200:
 *         description: Campaign deleted successfully
 *       404:
 *         description: Campaign not found
 *       500:
 *         description: Server error
 *
 * /api/v1/campaign:
 *   get:
 *     summary: Get list of campaigns
 *     tags: [Campaign]
 *     responses:
 *       200:
 *         description: List of campaigns
 *         content:
 *           application/json:
 *             schema:
 *               type: array
 *               items:
 *                 $ref: '#/components/schemas/Campaign'
 *       500:
 *         description: Server error
 */
