/**
 * @swagger
 * tags:
 *   name: BrandHome
 *   description: Əsas səhifədə görünən brendlər
 *
 * components:
 *   schemas:
 *     BrandHomeBase:
 *       type: object
 *       properties:
 *         image:
 *           type: string
 *           format: binary
 *           description: Şəkil faylı (PNG, JPG və s.)
 *         titleAz:
 *           type: string
 *         titleEn:
 *           type: string
 *         titleRu:
 *           type: string
 *         textAz:
 *           type: string
 *         textEn:
 *           type: string
 *         textRu:
 *           type: string
 *       required:
 *         - titleAz
 *         - titleEn
 *         - titleRu
 *         - textAz
 *         - textEn
 *         - textRu
 *
 * /api/v1/ad/brandhome:
 *   post:
 *     summary: Əsas səhifəyə yeni brend əlavə et
 *     tags: [BrandHome]
 *     requestBody:
 *       required: true
 *       content:
 *         multipart/form-data:
 *           schema:
 *             $ref: '#/components/schemas/BrandHomeBase'
 *     responses:
 *       201:
 *         description: Uğurla əlavə edildi
 *       400:
 *         description: Yanlış sorğu
 *       500:
 *         description: Server xətası
 *
 * /api/v1/brandhome:
 *   get:
 *     summary: Bütün brand-home siyahısı
 *     tags: [BrandHome]
 *     responses:
 *       200:
 *         description: Brendlər siyahısı
 *         content:
 *           application/json:
 *             schema:
 *               type: array
 *               items:
 *                 type: object
 *                 properties:
 *                   _id:
 *                     type: string
 *                   image:
 *                     type: string
 *                   titleAz:
 *                     type: string
 *                   titleEn:
 *                     type: string
 *                   titleRu:
 *                     type: string
 *                   textAz:
 *                     type: string
 *                   textEn:
 *                     type: string
 *                   textRu:
 *                     type: string
 *       500:
 *         description: Server xətası
 *
 * /api/v1/ad/brandhome/{id}:
 *   put:
 *     summary: Əsas səhifə brendini yenilə
 *     tags: [BrandHome]
 *     parameters:
 *       - in: path
 *         name: id
 *         required: true
 *         schema:
 *           type: string
 *         description: BrandHome ID-si
 *     requestBody:
 *       required: true
 *       content:
 *         multipart/form-data:
 *           schema:
 *             $ref: '#/components/schemas/BrandHomeBase'
 *     responses:
 *       200:
 *         description: Yeniləndi
 *       400:
 *         description: Yanlış sorğu
 *       404:
 *         description: Tapılmadı
 *       500:
 *         description: Server xətası
 *
 *   delete:
 *     summary: Əsas səhifə brendini sil
 *     tags: [BrandHome]
 *     parameters:
 *       - in: path
 *         name: id
 *         required: true
 *         schema:
 *           type: string
 *         description: BrandHome ID-si
 *     responses:
 *       200:
 *         description: Uğurla silindi
 *       404:
 *         description: Tapılmadı
 *       500:
 *         description: Server xətası
 */
