
/**
 * @swagger
 * tags:
 *   name: About
 *   description: About section management API
 */

/**
 * @swagger
 * components:
 *   schemas:
 *     About:
 *       type: object
 *       properties:
 *         image:
 *           type: string
 *           description: Image URL or path
 *         titleAz:
 *           type: string
 *           description: Title in Azerbaijani
 *         titleEn:
 *           type: string
 *           description: Title in English
 *         titleRu:
 *           type: string
 *           description: Title in Russian
 *         textAz:
 *           type: string
 *           description: Text in Azerbaijani
 *         textEn:
 *           type: string
 *           description: Text in English
 *         textRu:
 *           type: string
 *           description: Text in Russian
 *       example:
 *         image: "https://example.com/images/about.jpg"
 *         titleAz: "Haqqımızda"
 *         titleEn: "About Us"
 *         titleRu: "О нас"
 *         textAz: "Şirkətimizin tarixi və məqsədləri."
 *         textEn: "History and goals of our company."
 *         textRu: "История и цели нашей компании."
 */

/**
 * @swagger
 * /api/v1/ad/about:
 *   put:
 *     summary: Update about section
 *     tags: [About]
 *     requestBody:
 *       required: false
 *       content:
 *         multipart/form-data:
 *           schema:
 *             type: object
 *             properties:
 *               image:
 *                 type: string
 *                 format: binary
 *               titleAz:
 *                 type: string
 *               titleEn:
 *                 type: string
 *               titleRu:
 *                 type: string
 *               textAz:
 *                 type: string
 *               textEn:
 *                 type: string
 *               textRu:
 *                 type: string
 *     responses:
 *       200:
 *         description: About section updated successfully
 *       400:
 *         description: Bad request
 *       500:
 *         description: Server error
  */


/**
 * @swagger
 * /api/v1/about:
 *   get:
 *     summary: Get about section details
 *     tags: [About]
 *     responses:
 *       200:
 *         description: About section details
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/About'
 *       404:
 *         description: About section not found
 *       500:
 *         description: Server error
  */





