const express = require('express');
const connectdb = require('./config/connectdb');
const cors = require('cors');
const app = express();

//==============================================middleware start===========================================
app.use(cors());
app.use(express.json());

//===========================================swagger start=================================================
const swaggerUi = require('swagger-ui-express');
const swaggerDocs = require('./swagger');

app.use('/api-docs', swaggerUi.serve, swaggerUi.setup(swaggerDocs));


//==========================================accesstoken start===============================================
const accesstoken = require("./middlewares/accesstoken");
app.use(accesstoken);

//==========================================surface route start=============================================
const surfaceRoute = require('./routers/client/surface');
app.use('/api/v1/',surfaceRoute);

//=========================================auth token start=================================================
const auth = require("./middlewares/auth");
app.use(auth);


//==============================================need auth route start=======================================
const needAuthRoute = require('./routers/client/needAuth.js');
app.use('/api/v1/',needAuthRoute);

//=========================================admin token start=================================================
const isAdmin = require("./middlewares/isAdmin");
app.use(isAdmin);


//=============================================admin routes start===========================================
const apiStartName = "/api/v1/ad";

const userRoute = require('./routers/admin/user.js');

const generalinfoRoute = require('./routers/admin/generalinfo.js');

const sliderRoute = require('./routers/admin/slider.js');
const aboutRoute = require('./routers/admin/about.js');
const campaignRoute = require('./routers/admin/campaign.js');
const brandHomeRoute = require('./routers/admin/brandHome.js');


const productRoute = require('./routers/admin/product/product.js');
const categoryRoute = require('./routers/admin/product/category.js'); 
const colorRoute = require('./routers/admin/product/color.js'); 
const brandRoute = require('./routers/admin/product/brand.js'); 

app.use(`${apiStartName}/user`,userRoute);

app.use(`${apiStartName}/generalinfo`,generalinfoRoute);

app.use(`${apiStartName}/slider`,sliderRoute);
app.use(`${apiStartName}/about`,aboutRoute);
app.use(`${apiStartName}/campaign`,campaignRoute);
app.use(`${apiStartName}/brandhome`,brandHomeRoute); 

app.use(`${apiStartName}/product`,productRoute);
app.use(`${apiStartName}/category`,categoryRoute); 
app.use(`${apiStartName}/color`,colorRoute); 
app.use(`${apiStartName}/brand`,brandRoute); 









connectdb();
app.listen(3001, () => {
    console.log('3001 port is running');
});
