const express = require('express');
const router = express.Router();

const { login, register } = require("../../controllers/auth/auth");
const {sliderList} = require('../../controllers/slider.js'); 
const {aboutList} = require('../../controllers/about.js'); 
const {campaignList} = require('../../controllers/campaign.js'); 
const {generalinfoList} = require('../../controllers/generalinfo.js');

const {productAllList,productFindBySlug} = require('../../controllers/product/product.js'); 
const {categoryList} = require('../../controllers/product/category.js'); 
const {brandList} = require('../../controllers/product/brand.js'); 
const {colorList} = require('../../controllers/product/color.js');

const {searchAllData} = require('../../controllers/generalinfo.js');

const {brandHomeList} = require('../../controllers/brandHome.js')

router.get('/search', searchAllData);

router.get('/slider', sliderList);
router.get('/about', aboutList);
router.get('/campaign', campaignList);
router.get('/generalinfo', generalinfoList);
router.get('/brandhome',brandHomeList);

router.get('/product', productAllList);
router.get('/product/:slug', productFindBySlug);
router.get('/category', categoryList); 
router.get('/brand', brandList);
router.get('/color', colorList); 


router.post('/auth/login',login);
router.post('/auth/register',register);


module.exports = router;
