
const express = require("express");
const { wishlistListByUser, wishlistEditByUser, wishlistAdd } = require("../../controllers/auth/wishlist.js");
const { userEdit, userSingle } = require("../../controllers/auth/user.js");
const { logout } = require("../../controllers/auth/auth");
const router = express.Router();



router.get('/wishlist/:user',wishlistListByUser);
router.post('/wishlist/:user',wishlistAdd);
router.put('/wishlist/:user',wishlistEditByUser);



router.get('/account/:id',userSingle);
router.put('/account/:id',userEdit);

router.post('/account/logout',logout);








module.exports = router;

