const express = require("express");
const router = express.Router();
const {
  productAdd,
  productEdit,
  productDelete,
} = require("../../../controllers/product/product");
const upload = require("../../../middlewares/uploadFile");

router.post("/",upload.fields([{ name: "thumbnail", maxCount: 1 },{ name: "images", maxCount: 10 },]),productAdd);

router.put("/:id",upload.fields([{ name: "thumbnail", maxCount: 1 },{ name: "images", maxCount: 10 },]),productEdit);

router.delete("/:id", productDelete);

module.exports = router;
