const express = require('express');
const router = express.Router();
const {
  categoryAdd,
  categoryEdit,
  categoryDel,
} = require('../../../controllers/product/category.js');
const upload = require('../../../middlewares/uploadFile.js');

router.post('/', upload.single('image'), categoryAdd);

router.put('/:id', upload.single('image'), categoryEdit);

router.delete('/:id', categoryDel);

module.exports = router;
