const Joi = require('joi');
const { default: mongoose } = require('mongoose');

const sliderSchema = mongoose.Schema({
  row: Number,
  slug: String,
  image: String,
  titleAz: String,
  titleEn: String,
  titleRu: String,
  textAz: String,
  textEn: String,
  textRu: String,
  btnUrl: String,
});

const sliderValidate = (data) => {
  const schema = new Joi.object({
    row: Joi.number(),
    slug: Joi.string(),
    image: Joi.string(),
    titleAz: Joi.string(),
    titleEn: Joi.string(),
    titleRu: Joi.string(),
    textAz: Joi.string(),
    textEn: Joi.string(),
    textRu: Joi.string(),
    btnUrl: Joi.string(),
  });

  return schema.validate(data);
};

const Slider = mongoose.model('Slider', sliderSchema);

module.exports = { Slider, sliderValidate };
