const { json } = require('express');
const Joi = require('joi');
const { default: mongoose, Schema } = require('mongoose');

const productSchema = mongoose.Schema({
  slug: String,
  productID: String,

  images: Array,
  thumbnail: Array,

  titleAz: String,
  titleEn: String,
  titleRu: String,

  price: Number,
  discountPrice: Number,

  textAz: String,
  textEn: String,
  textRu: String,

  category: { type: String, ref: 'Category' },
  campaign: { type: String, ref: 'Campaign' },
  color: { type: String, ref: 'Color' },
  brand: { type: String, ref: 'Brand' },
  gender: {
    type: String,
    enum: ['male', 'female', 'uni', 'boy', 'girl'],
    default: 'uni',
  },
  recommended: {
    type: Boolean,
    default: false,
  },
  bestSeller: {
    type: Boolean,
    default: false,
  },

  stock: {
    type: Number,
    default: 1,
  },
});

const productValidate = (data) => {
  const schema = new Joi.object({
    slug: Joi.string(),
    productID: Joi.string(),

    images: Joi.array(),
    thumbnail: Joi.string(),

    titleAz: Joi.string(),
    titleEn: Joi.string(),
    titleRu: Joi.string(),

    price:Joi.string(),
    discountPrice:Joi.string(),

    textAz: Joi.string(),
    textEn: Joi.string(),
    textRu: Joi.string(),

    category: Joi.string(),
    campaign: Joi.string(),
    color: Joi.string(),
    brand: Joi.string(),
    gender: Joi.string(),

    recommended: Joi.boolean(),
    bestSeller: Joi.boolean(),

    stock: Joi.number(),
  });

  return schema.validate(data);
};

const Product = mongoose.model('Product', productSchema);

module.exports = { Product, productValidate };
