const Joi = require('joi');
const { default: mongoose } = require('mongoose');

const colorSchema = mongoose.Schema({
  row: Number,
  slug: String,
  titleAz: String,
  titleEn: String,
  titleRu: String,
  colorCode: String,
});

const colorValidate = (data) => {
  const schema = new Joi.object({
    row: Joi.number(),
    slug: Joi.string(),
    titleAz: Joi.string(),
    titleEn: Joi.string(),
    titleRu: Joi.string(),
    colorCode: Joi.string(),
  });

  return schema.validate(data);
};

const Color = mongoose.model('Color', colorSchema);

module.exports = { Color, colorValidate };
