const Joi = require('joi');
const { default: mongoose, Schema } = require('mongoose');

const categorySchema = mongoose.Schema({
  row: Number,
  slug: String,
  image: String,
  titleAz: String,
  titleEn: String,
  titleRu: String,
  textAz: String,
  textEn: String,
  textRu: String,
  homePageShow: {
    type: Boolean,
    default: false,
  },
});

const categoryValidate = (data) => {
  const schema = new Joi.object({
    row: Joi.number(),
    slug: Joi.string(),
    image: Joi.string(),
    titleAz: Joi.string(),
    titleEn: Joi.string(),
    titleRu: Joi.string(),
    textAz: Joi.string(),
    textEn: Joi.string(),
    textRu: Joi.string(),
    homePageShow: Joi.boolean(),
  });

  return schema.validate(data);
};

const Category = mongoose.model('Category', categorySchema);

module.exports = { Category, categoryValidate };
