
const Joi = require("joi");
const { default: mongoose } = require("mongoose");

const brandSchema = mongoose.Schema({
  row:Number,
  slug:String,
  titleAz: String,  
  titleEn: String, 
  titleRu: String, 
});

const brandValidate = (data) => {
  const schema = new Joi.object({
    row:Joi.number(),
    slug:Joi.string(),
    titleAz: Joi.string(), 
    titleEn: Joi.string(), 
    titleRu: Joi.string(), 
  });

  return schema.validate(data);
};

const Brand = mongoose.model("Brand", brandSchema);

module.exports = { Brand, brandValidate };
