const Joi = require('joi');
const { default: mongoose } = require('mongoose');

const generalinfoSchema = mongoose.Schema({
  phoneNumber: String,
  email: String,

  addressAz: String,
  addressEn: String,
  addressRu: String,

  whatsappUrl: String,
  fbUrl: String,
  instagramUrl: String,
  youtubeUrl: String,
  linkedinUrl: String,
  tiktokUrl: String,
  twitterUrl: String,
});

const generalinfoValidate = (generalinfo) => {
  const schema = new Joi.object({
    phoneNumber: Joi.string(),
    email: Joi.string(),

    addressAz: Joi.string(),
    addressEn: Joi.string(),
    addressRu: Joi.string(),

    whatsappUrl: Joi.string(),
    fbUrl: Joi.string(),
    instagramUrl: Joi.string(),
    youtubeUrl: Joi.string(),
    linkedinUrl: Joi.string(),
    tiktokUrl: Joi.string(),
    twitterUrl: Joi.string(),

  });

  return schema.validate(generalinfo);
};

const Generalinfo = mongoose.model('Generalinfo', generalinfoSchema);

module.exports = { Generalinfo, generalinfoValidate };
