const Joi = require('joi');
const { default: mongoose } = require('mongoose');

const campaignSchema = mongoose.Schema(
  {
    row: Number,
    slug: String,
    image: String,
    titleAz: String,
    titleEn: String,
    titleRu: String,
    textAz: String,
    textEn: String,
    textRu: String,
    startDate: String,
    endDate: String,
  },
  { timestamps: true }
);

const campaignValidate = (data) => {
  const schema = new Joi.object({
    row: Joi.number(),
    slug: Joi.string(),
    image: Joi.string(),
    titleAz: Joi.string(),
    titleEn: Joi.string(),
    titleRu: Joi.string(),
    textAz: Joi.string(),
    textEn: Joi.string(),
    textRu: Joi.string(),
    startDate: Joi.string(),
    endDate: Joi.string(),
  });

  return schema.validate(data);
};

const Campaign = mongoose.model('Campaign', campaignSchema);

module.exports = { Campaign, campaignValidate };
