
const Joi = require('joi');
const { default: mongoose } = require('mongoose');

const brandHomeSchema = mongoose.Schema({
  row: Number,
  slug: String,
  image: String,
  titleAz: String,
  titleEn: String,
  titleRu: String,
  textAz: String,
  textEn: String,
  textRu: String,
});

const brandHomeValidate = (data) => {
  const schema = new Joi.object({
    row: Joi.number(),
    slug: Joi.string(),
    image: Joi.string(),
    titleAz: Joi.string(),
    titleEn: Joi.string(),
    titleRu: Joi.string(),
    textAz: Joi.string(),
    textEn: Joi.string(),
    textRu: Joi.string(),
  });

  return schema.validate(data);
};

const BrandHome = mongoose.model('BrandHome', brandHomeSchema);

module.exports = { BrandHome, brandHomeValidate };
