const Joi = require("joi");
const { default: mongoose, Schema } = require("mongoose");

const wishlistSchema = Schema(
  {
    user: { type: Schema.Types.ObjectId, ref: "User" },
    products: [{ type: Schema.Types.ObjectId, ref: "Product" }],
  },
  { timestamps: true }
);

const wishlistValidate = (wishlist) => {
  const schema = new Joi.object({
    user: Joi.string().required(),
    products: Joi.array(),
  });

  return schema.validate(wishlist);
};

const Wishlist = mongoose.model("Wishlist", wishlistSchema);

module.exports = { Wishlist, wishlistValidate };
