const Joi = require("joi");
const { default: mongoose,Schema } = require("mongoose");
const jwt = require('jsonwebtoken');

const userSchema = mongoose.Schema({
    name: String,
    surname: String,
    phone:String,
    email: String,
    gender: {
        type: String,
        enum: ['male', 'female','rather not say'],
        default:'rather not say'
      },
    password: String,
    role:{
        type:String,
        enum:['admin','user'],
        default:'user'
    }
}, { timestamps: true });


const userValidate = (user) => {
    const schema = new Joi.object({
        name: Joi.string(),
        surname: Joi.string(),
        phone: Joi.string(),
        email: Joi.string(),
        gender:Joi.string(),
        password: Joi.string(),
        role: Joi.string()
    })

        return schema.validate(user);
}


userSchema.methods.createAuthToken = function () {
    const decodedToken = jwt.sign({ _id: this._id, role:this.role }, 'jwtPrivateKey',{ expiresIn: '7d' })
    return decodedToken;
}

const User = mongoose.model("User", userSchema);

module.exports = { User, userValidate }
