const Joi = require("joi");

const registerValidate = (data) => {
    const schema = new Joi.object({
        name: Joi.string().required(),
        surname: Joi.string().required(),
        phone: Joi.string().required(),
        email: Joi.string().min(7).max(200).email().required(),
        gender:Joi.string(),
        password: Joi.string().min(8).required(),
    })

    return schema.validate(data);
}

const loginValidate = (data) => {
    const schema = new Joi.object({
        email: Joi.string().min(7).max(200).email().required(),
        password: Joi.string().min(8).required(),
    })

    return schema.validate(data);
    
}


module.exports = { registerValidate,loginValidate }
