const Joi = require('joi');
const { default: mongoose } = require('mongoose');

const aboutSchema = mongoose.Schema({
  image: String,
  titleAz: String,
  titleEn: String,
  titleRu: String,
  textAz: String,
  textEn: String,
  textRu: String,
});

const aboutValidate = (about) => {
  const schema = new Joi.object({
    image: Joi.string(),
    titleAz: Joi.string(),
    titleEn: Joi.string(),
    titleRu: Joi.string(),
    textAz: Joi.string(),
    textEn: Joi.string(),
    textRu: Joi.string(),
  });

  return schema.validate(about);
};

const About = mongoose.model('About', aboutSchema);

module.exports = { About, aboutValidate };
