
const jwt = require("jsonwebtoken");

module.exports = function (req, res, next) {
  const token = req.header("ktkoptika-auth-token");
  if (!token) {
    return res.status(401).json({
      "az":"Sizin səlahiyyətiniz yoxdur!",
      "en":"You do not have authority!",
      "ru":"У вас нет полномочий!",
    });
  }

  try {
    const decodedToken = jwt.verify(token, "jwtPrivateKey");
    req.user = decodedToken;
    next();
  } catch (ex) {
    res.status("wrong token");
  }
};
