const { default: slugify } = require('slugify');
const { Slider, sliderValidate } = require('../models/slider');
const { deleteSingleOldImage } = require('../utils/deleteOldImage');
const { idForSlug } = require('../utils/idGenerator');

exports.sliderList = async (req, res) => {
  const slider = await Slider.find();
  res.status(200).json(slider);
};

exports.sliderAdd = async (req, res) => {
  const { error } = sliderValidate(req.body);
  let result;
  let slider;
  if (error) {
    res.status(400).send(error.message);
  } else {
    slider = new Slider(req.body);
    const lastSlider = await Slider.findOne().sort({ row: -1 });
    if (!lastSlider) {
      slider.row = 1;
    } else {
      slider.row = lastSlider.row + 1;
    }

    slider.slug =
      slugify(req.body.titleEn, { lower: true }) + '-' + idForSlug();

    if (!req.file) {
      result = await slider.save();
      res.status(201).json({
        message: {
          az: 'Məlumat uğurla əlavə edildi.',
          en: 'Information added successfully.',
          ru: 'Информация успешно добавлена.',
        },
        data: result,
      });
    } else {
      slider.image = req.file.path;
      result = await slider.save();
      res.status(201).json({
        message: {
          az: 'Məlumat uğurla əlavə edildi.',
          en: 'Information added successfully.',
          ru: 'Информация успешно добавлена.',
        },
        data: result,
      });
    }
  }
};

exports.sliderEdit = async (req, res) => {
  const { error } = sliderValidate(req.body);
  if (error) {
    res.status(400).send(error.message);
  } else {
    const slider = await Slider.findById(req.params.id);

    if (!slider) {
      return res.status(404).json({
        az: 'Belə bir məlumat yoxdur.',
        en: 'There is no such data.',
        ru: 'Таких данных нет.',
      });
    } else {
      if (!req.file) {
        const slider = await Slider.findByIdAndUpdate(req.params.id, {
          ...req.body,
        });
        slider.slug =
          slugify(req.body.titleEn, { lower: true }) + '-' + idForSlug();
        await slider.save();

        res.status(200).json({
          message: {
            az: 'Məlumat uğurla yeniləndi.',
            en: 'Information updated successfully.',
            ru: 'Информация успешно обновлена.',
          },
          data: slider,
        });
      } else {
        const slider = await Slider.findByIdAndUpdate(req.params.id, {
          ...req.body,
        });
        slider.slug =
          slugify(req.body.titleEn, { lower: true }) + '-' + idForSlug();
        const oldImages = slider.image;
        deleteSingleOldImage(oldImages);
        slider.image = req.file.path;
        await slider.save();
        res.status(200).json({
          message: {
            az: 'Məlumat uğurla yeniləndi.',
            en: 'Information updated successfully.',
            ru: 'Информация успешно обновлена.',
          },
          data: slider,
        });
      }
    }
  }
};

exports.sliderDel = async (req, res) => {
  const slider = await Slider.findByIdAndDelete(req.params.id);
  if (!slider) {
    return res.status(404).json({
      az: 'Belə bir məlumat yoxdur.',
      en: 'There is no such data.',
      ru: 'Таких данных нет.',
    });
  } else {
    deleteSingleOldImage(slider.image);
    res.status(200).json({
      message: {
        az: 'Məlumat uğurla silindi.',
        en: 'The information was deleted successfully.',
        ru: 'Информация успешно удалена.',
      },
      data: slider,
    });
  }
};

// ============================ slider end ===============================
