const { default: slugify } = require('slugify');
const { Color, colorValidate } = require('../../models/product/color');
const { idForSlug } = require('../../utils/idGenerator');

exports.colorList = async (req, res) => {
  const color = await Color.find();
  res.status(200).json(color);
};

exports.colorAdd = async (req, res) => {
  const { error } = colorValidate(req.body);
  let result;
  let color;
  if (error) {
    res.status(400).send(error.message);
  } else {
    color = new Color(req.body);
    const lastColor = await Color.findOne().sort({ row: -1 });
    if (!lastColor) {
      color.row = 1;
    } else {
      color.row = lastColor.row + 1;
    }

    color.slug = slugify(req.body.titleEn, { lower: true }) + '-' + idForSlug();
    result = await color.save();
    res.status(201).json({
      message: {
        az: 'Məlumat uğurla əlavə edildi.',
        en: 'Information added successfully.',
        ru: 'Информация успешно добавлена.',
      },
      data: result,
    });
  }
};

exports.colorEdit = async (req, res) => {
  const { error } = colorValidate(req.body);
  if (error) {
    res.status(400).send(error.message);
  } else {
    const color = await Color.findById(req.params.id);
    if (!color) {
      return res.status(404).json({
        az: 'Belə bir məlumat yoxdur.',
        en: 'There is no such data.',
        ru: 'Таких данных нет.',
      });
    } else {
      const color = await Color.findByIdAndUpdate(req.params.id, {
        ...req.body,
      });
      await color.save();
      res.status(200).json({
        message: {
          az: 'Məlumat uğurla yeniləndi.',
          en: 'Information updated successfully.',
          ru: 'Информация успешно обновлена.',
        },
        data: color,
      });
    }
  }
};

exports.colorDel = async (req, res) => {
  const color = await Color.findByIdAndDelete(req.params.id);
  if (!color) {
    return res.status(404).json({
      az: 'Belə bir məlumat yoxdur.',
      en: 'There is no such data.',
      ru: 'Таких данных нет.',
    });
  }
  res.status(200).json({
    message: {
      az: 'Məlumat uğurla silindi.',
      en: 'The information was deleted successfully.',
      ru: 'Информация успешно удалена.',
    },
    data: color,
  });
};

// ============================ color end ===============================
