const { default: slugify } = require('slugify');
const {
  Category,
  categoryValidate,
} = require('../../models/product/category.js');
const { deleteSingleOldImage } = require('../../utils/deleteOldImage');
const { idForSlug } = require('../../utils/idGenerator');

exports.categoryList = async (req, res) => {
  const category = await Category.find();
  res.status(200).json(category);
};

exports.categoryAdd = async (req, res) => {
  const { error } = categoryValidate(req.body);
  let result;
  let category;
  if (error) {
    res.status(400).send(error.message);
  } else {
    category = new Category(req.body);
    const lastCategory = await Category.findOne().sort({ row: -1 });
    if (!lastCategory) {
      category.row = 1;
    } else {
      category.row = lastCategory.row + 1;
    }

    category.slug =
      slugify(req.body.titleEn, { lower: true }) + '-' + idForSlug();

    if (!req.file) {
      result = await category.save();
      res.status(201).json({
        message: {
          az: 'Məlumat uğurla əlavə edildi.',
          en: 'Information added successfully.',
          ru: 'Информация успешно добавлена.',
        },
        data: result,
      });
    } else {
      category.image = req.file.path;
      result = await category.save();
      res.status(201).json({
        message: {
          az: 'Məlumat uğurla əlavə edildi.',
          en: 'Information added successfully.',
          ru: 'Информация успешно добавлена.',
        },
        data: result,
      });
    }
  }
};

exports.categoryEdit = async (req, res) => {
  const { error } = categoryValidate(req.body);
  if (error) {
    res.status(400).send(error.message);
  } else {
    const category = await Category.findById(req.params.id);

    if (!category) {
      return res.status(404).json({
        az: 'Belə bir məlumat yoxdur.',
        en: 'There is no such data.',
        ru: 'Таких данных нет.',
      });
    } else {
      if (!req.file) {
        const category = await Category.findByIdAndUpdate(req.params.id, {
          ...req.body,
        });
        category.slug =
          slugify(req.body.titleEn, { lower: true }) + '-' + idForSlug();
        await category.save();

        res.status(200).json({
          message: {
            az: 'Məlumat uğurla yeniləndi.',
            en: 'Information updated successfully.',
            ru: 'Информация успешно обновлена.',
          },
          data: category,
        });
      } else {
        const category = await Category.findByIdAndUpdate(req.params.id, {
          ...req.body,
        });
        category.slug =
          slugify(req.body.titleEn, { lower: true }) + '-' + idForSlug();
        const oldImages = category.image;
        deleteSingleOldImage(oldImages);
        category.image = req.file.path;
        await category.save();
        res.status(200).json({
          message: {
            az: 'Məlumat uğurla yeniləndi.',
            en: 'Information updated successfully.',
            ru: 'Информация успешно обновлена.',
          },
          data: category,
        });
      }
    }
  }
};

exports.categoryDel = async (req, res) => {
  let category;
  if (req.file) {
    category = await Category.findByIdAndDelete(req.params.id);
    if (!category) {
      return res.status(404).json({
        az: 'Belə bir məlumat yoxdur.',
        en: 'There is no such data.',
        ru: 'Таких данных нет.',
      });
    }
    deleteSingleOldImage(category.image);
  } else {
    category = await Category.findByIdAndDelete(req.params.id);
    if (!category) {
      return res.status(404).json({
        az: 'Belə bir məlumat yoxdur.',
        en: 'There is no such data.',
        ru: 'Таких данных нет.',
      });
    }
  }
  res.status(200).json({
    message: {
      az: 'Məlumat uğurla silindi.',
      en: 'The information was deleted successfully.',
      ru: 'Информация успешно удалена.',
    },
    data: category,
  });
};

// ============================ category end ===============================
