const { default: slugify } = require('slugify');
const { Brand, brandValidate } = require('../../models/product/brand');
const { idForSlug } = require('../../utils/idGenerator');

exports.brandList = async (req, res) => {
  const brand = await Brand.find();
  res.status(200).json(brand);
};

exports.brandAdd = async (req, res) => {
  const { error } = brandValidate(req.body);
  let result;
  let brand;
  if (error) {
    res.status(400).send(error.message);
  } else {
    brand = new Brand(req.body);
    const lastBrand = await Brand.findOne().sort({ row: -1 });
    if (!lastBrand) {
      brand.row = 1;
    } else {
      brand.row = lastBrand.row + 1;
    }

    brand.slug = slugify(req.body.titleEn, { lower: true }) + '-' + idForSlug();
    result = await brand.save();
    res.status(201).json({
      message: {
        az: 'Məlumat uğurla əlavə edildi.',
        en: 'Information added successfully.',
        ru: 'Информация успешно добавлена.',
      },
      data: result,
    });
  }
};

exports.brandEdit = async (req, res) => {
  const { error } = brandValidate(req.body);
  if (error) {
    res.status(400).send(error.message);
  } else {
    const brand = await Brand.findById(req.params.id);
    if (!brand) {
      return res.status(404).json({
        az: 'Belə bir məlumat yoxdur.',
        en: 'There is no such data.',
        ru: 'Таких данных нет.',
      });
    } else {
      const brand = await Brand.findByIdAndUpdate(req.params.id, {
        ...req.body,
      });
      await brand.save();
      res.status(200).json({
        message: {
          az: 'Məlumat uğurla yeniləndi.',
          en: 'Information updated successfully.',
          ru: 'Информация успешно обновлена.',
        },
        data: brand,
      });
    }
  }
};

exports.brandDel = async (req, res) => {
  const brand = await Brand.findByIdAndDelete(req.params.id);
  if (!brand) {
    return res.status(404).json({
      az: 'Belə bir məlumat yoxdur.',
      en: 'There is no such data.',
      ru: 'Таких данных нет.',
    });
  }
  res.status(200).json({
    message: {
      az: 'Məlumat uğurla silindi.',
      en: 'The information was deleted successfully.',
      ru: 'Информация успешно удалена.',
    },
    data: brand,
  });
};

// ============================ brand end ===============================
