const { Generalinfo, generalinfoValidate } = require('../models/generalinfo');
const { default: mongoose } = require('mongoose');

exports.searchAllData = async (req, res) => {
  try {
    let { searchTerm, page = 1, limit = 10 } = req.query;

    if (!searchTerm) {
      return res.status(400).json({ message:
        {
          az:"Axtarış zamanı heç bir məlumat əldə edilmədi.",
          en:"No information was obtained during the search.",
          ru:"В ходе обыска никакой информации получено не было."
        }});
    }

    page = Number(page);
    limit = Number(limit);

    const collections = await mongoose.connection.db
      .listCollections()
      .toArray();

    const searchResults = {};
    const promises = [];

    for (let i = 0; i < collections.length; i++) {
      const collectionName = collections[i].name;
      const collection = mongoose.connection.db.collection(collectionName);

      const promise = collection
        .find({
          $or: [
            { titleAz: { $regex: searchTerm, $options: 'i' } },
            { titleEn: { $regex: searchTerm, $options: 'i' } },
            { titleRu: { $regex: searchTerm, $options: 'i' } },
          ],
        })
        .skip((page - 1) * limit)
        .limit(limit)
        .toArray();

      promises.push(promise);
    }

    const results = await Promise.all(promises);

    results.forEach((result, index) => {
      if (result.length > 0) {
        searchResults[collections[index].name] = result;
      }
    });

    res.status(200).json(searchResults);
  } catch (error) {
    console.error(error);
    res.status(500).json({ message: 'Server error' });
  }
};

exports.generalinfoList = async (req, res) => {
  const generalinfo = await Generalinfo.find();
  res.status(200).json(generalinfo);
};

exports.generalinfoAdd = async (req, res) => {
  const { error } = generalinfoValidate(req.body);
  let result;
  let generalinfo;
  if (error) {
    res.status(400).send(error.message);
  } else {
    generalinfo = new Generalinfo(req.body);
    result = await generalinfo.save();
    res.status(201).json({
      message: {
        az: 'Məlumat uğurla əlavə edildi.',
        en: 'Information added successfully.',
        ru: 'Информация успешно добавлена.',
      },
      data: result,
    });
  }
};
exports.generalinfoEdit = async (req, res) => {
  const { error } = generalinfoValidate(req.body);
  if (error) {
    res.status(400).send(error.message);
  } else {
    const generalinfo = await Generalinfo.findByIdAndUpdate(
      '68691c253206ca642692f553',
      {
        ...req.body,
      }
    );
    await generalinfo.save();

    res.status(200).json({
      message: {
        az: 'Məlumat uğurla yeniləndi.',
        en: 'Information updated successfully.',
        ru: 'Информация успешно обновлена.',
      },
      data: generalinfo,
    });
  }
};

// ============================ generalinfo end ===============================
