const { default: slugify } = require('slugify');
const { Campaign, campaignValidate } = require('../models/campaign');
const { deleteSingleOldImage } = require('../utils/deleteOldImage');
const { idForSlug } = require('../utils/idGenerator');

exports.campaignList = async (req, res) => {
  const campaign = await Campaign.find();
  res.status(200).json(campaign);
};

exports.campaignAdd = async (req, res) => {
  const { error } = campaignValidate(req.body);
  let result;
  let campaign;
  if (error) {
    res.status(400).send(error.message);
  } else {
    campaign = new Campaign(req.body);
    const lastCampaign = await Campaign.findOne().sort({ row: -1 });
    if (!lastCampaign) {
      campaign.row = 1;
    } else {
      campaign.row = lastCampaign.row + 1;
    }

    campaign.slug =
      slugify(req.body.titleEn, { lower: true }) + '-' + idForSlug();

    if (!req.file) {
      result = await campaign.save();
      res.status(201).json({
        message: {
          az: 'Məlumat uğurla əlavə edildi.',
          en: 'Information added successfully.',
          ru: 'Информация успешно добавлена.',
        },
        data: result,
      });
    } else {
      campaign.image = req.file.path;
      result = await campaign.save();
      res.status(201).json({
        message: {
          az: 'Məlumat uğurla əlavə edildi.',
          en: 'Information added successfully.',
          ru: 'Информация успешно добавлена.',
        },
        data: result,
      });
    }
  }
};

exports.campaignEdit = async (req, res) => {
  const { error } = campaignValidate(req.body);
  if (error) {
    res.status(400).send(error.message);
  } else {
    const campaign = await Campaign.findById(req.params.id);

    if (!campaign) {
      return res.status(404).json({
        az: 'Belə bir məlumat yoxdur.',
        en: 'There is no such data.',
        ru: 'Таких данных нет.',
      });
    } else {
      if (!req.file) {
        const campaign = await Campaign.findByIdAndUpdate(req.params.id, {
          ...req.body,
        });
        campaign.slug =
          slugify(req.body.titleEn, { lower: true }) + '-' + idForSlug();
        await campaign.save();

        res.status(200).json({
          message: {
            az: 'Məlumat uğurla yeniləndi.',
            en: 'Information updated successfully.',
            ru: 'Информация успешно обновлена.',
          },
          data: campaign,
        });
      } else {
        const campaign = await Campaign.findByIdAndUpdate(req.params.id, {
          ...req.body,
        });
        campaign.slug =
          slugify(req.body.titleEn, { lower: true }) + '-' + idForSlug();
        const oldImages = campaign.image;
        deleteSingleOldImage(oldImages);
        campaign.image = req.file.path;
        await campaign.save();
        res.status(200).json({
          message: {
            az: 'Məlumat uğurla yeniləndi.',
            en: 'Information updated successfully.',
            ru: 'Информация успешно обновлена.',
          },
          data: campaign,
        });
      }
    }
  }
};

exports.campaignDel = async (req, res) => {
  const campaign = await Campaign.findByIdAndDelete(req.params.id);
  if (!campaign) {
    return res.status(404).json({
      az: 'Belə bir məlumat yoxdur.',
      en: 'There is no such data.',
      ru: 'Таких данных нет.',
    });
  }
  deleteSingleOldImage(campaign.image);
   res.status(200).json({
      message: {
        az: 'Məlumat uğurla silindi.',
        en: 'The information was deleted successfully.',
        ru: 'Информация успешно удалена.',
      },
      data: campaign,
    });

};

// ============================ campaign end ===============================
