
const { default: slugify } = require('slugify');
const { BrandHome, brandHomeValidate } = require('../models/brandHome.js');
const { deleteSingleOldImage } = require('../utils/deleteOldImage');
const { idForSlug } = require('../utils/idGenerator');

exports.brandHomeList = async (req, res) => {
  const brandHome = await BrandHome.find();
  res.status(200).json(brandHome);
};

exports.brandHomeAdd = async (req, res) => {
  const { error } = brandHomeValidate(req.body);
  let result;
  let brandHome;
  if (error) {
    res.status(400).send(error.message);
  } else {
    brandHome = new BrandHome(req.body);
    const lastbrandHome = await BrandHome.findOne().sort({ row: -1 });
    if (!lastbrandHome) {
      brandHome.row = 1;
    } else {
      brandHome.row = lastbrandHome.row + 1;
    }

    brandHome.slug =
      slugify(req.body.titleEn, { lower: true }) + '-' + idForSlug();

    if (!req.file) {
      result = await brandHome.save();
      res.status(201).json({
        message: {
          az: 'Məlumat uğurla əlavə edildi.',
          en: 'Information added successfully.',
          ru: 'Информация успешно добавлена.',
        },
        data: result,
      });
    } else {
      brandHome.image = req.file.path;
      result = await brandHome.save();
      res.status(201).json({
        message: {
          az: 'Məlumat uğurla əlavə edildi.',
          en: 'Information added successfully.',
          ru: 'Информация успешно добавлена.',
        },
        data: result,
      });
    }
  }
};

exports.brandHomeEdit = async (req, res) => {
  const { error } = brandHomeValidate(req.body);
  if (error) {
    res.status(400).send(error.message);
  } else {
    const brandHome = await BrandHome.findById(req.params.id);

    if (!brandHome) {
      return res.status(404).json({
        az: 'Belə bir məlumat yoxdur.',
        en: 'There is no such data.',
        ru: 'Таких данных нет.',
      });
    } else {
      if (!req.file) {
        const brandHome = await BrandHome.findByIdAndUpdate(req.params.id, {
          ...req.body,
        });
        brandHome.slug =
          slugify(req.body.titleEn, { lower: true }) + '-' + idForSlug();
        await brandHome.save();

        res.status(200).json({
          message: {
            az: 'Məlumat uğurla yeniləndi.',
            en: 'Information updated successfully.',
            ru: 'Информация успешно обновлена.',
          },
          data: brandHome,
        });
      } else {
        const brandHome = await BrandHome.findByIdAndUpdate(req.params.id, {
          ...req.body,
        });
        brandHome.slug =
          slugify(req.body.titleEn, { lower: true }) + '-' + idForSlug();
        const oldImages = brandHome.image;
        deleteSingleOldImage(oldImages);
        brandHome.image = req.file.path;
        await brandHome.save();
        res.status(200).json({
          message: {
            az: 'Məlumat uğurla yeniləndi.',
            en: 'Information updated successfully.',
            ru: 'Информация успешно обновлена.',
          },
          data: brandHome,
        });
      }
    }
  }
};

exports.brandHomeDel = async (req, res) => {
  const brandHome = await BrandHome.findByIdAndDelete(req.params.id);
  if (!brandHome) {
    return res.status(404).json({
      az: 'Belə bir məlumat yoxdur.',
      en: 'There is no such data.',
      ru: 'Таких данных нет.',
    });
  }
  deleteSingleOldImage(brandHome.image);
   res.status(200).json({
      message: {
        az: 'Məlumat uğurla silindi.',
        en: 'The information was deleted successfully.',
        ru: 'Информация успешно удалена.',
      },
      data: brandHome,
    });

};

// ============================ brandHome end ===============================
