const { Wishlist, wishlistValidate } = require("../../models/auth/wishlist.js");
const { User } = require("../../models/auth/user");

exports.wishlistAdd = async (req, res) => {
  const { error } = wishlistValidate(req.body);
  if (error) {
    res.status(400).send(error.messages);
  } else {
    const user = await Wishlist.findOne({ user: req.params.user });
    if (user) {
      return res.status(400).json({
        az: "Bu istifadəçi üçün artıq wishlist mövcuddur!",
        en: "This user already has a wishlist!",
        ru: "У этого пользователя уже есть wishlist!",
      });
    } else {
      const wishlist = new Wishlist(req.body);
      wishlist.user = req.params.user;
      const result = await wishlist.save();
      res.status(200).json(result);
    }
  }
};

exports.wishlistListByUser = async (req, res) => {
  const user = await User.findById(req.params.user);
  const wishlist = await Wishlist.find({ user: req.params.user }).populate(
    "user products",
  );
  if (!user) {
    return res.status(404).json({
      az: "İstifadəçi mövcud deyil!",
      en: "User not exists!",
      ru: "Пользователь не существует!",
    });
  } else {
    if (!wishlist) {
      return res.status(404).json({
        az: "Bu istifadəçi üçün səbət mövcud deyil!",
        en: "wishlist not exists for this user!",
        ru: "Корзина не существует для этого пользователя!",
      });
    } else {
      return res.status(200).send(wishlist);
    }
  }
};

exports.wishlistEditByUser = async (req, res) => {
  const user = await User.findById(req.params.user);
  if (!user) {
    return res.status(404).json({
      az: "İstifadəçi mövcud deyil!",
      en: "User not exists!",
      ru: "Пользователь не существует!",
    });
  }

  const wishlist = await Wishlist.findOne({ user: req.params.user });
  if (!wishlist) {
    return res.status(404).json({
      az: "Bu istifadəçi üçün səbət mövcud deyil!",
      en: "wishlist not exists for this user!",
      ru: "Корзина не существует для этого пользователя!",
    });
  }

  Object.assign(wishlist, req.body);
  const result = await wishlist.save();
  res.status(200).json(result);
};
