const { User, userValidate } = require("../../models/auth/user");
const bcrypt = require("bcrypt");

exports.userList = async (req, res) => {
  const user = await User.find();
  res.send(user);
};

exports.userSingle = async (req, res) => {
  const user = await User.findById(req.params.id);
  res.send(user);
};

exports.userAdd = async (req, res) => {
  const { error } = userValidate(req.body);
  if (error) {
    res.status(400).send(error.messages);
  } else {
    const user = new User(req.body);
    const hashPassword = await bcrypt.hash(req.body.password, 10);
    user.password = hashPassword;
    const result = await user.save();
    res.status(200).json(result);
  }
};

exports.userEdit = async (req, res) => {
  const user = await User.findById(req.params.id);
  if (!user) {
    return res.status(404).json({
      az: "Belə bir məlumat yoxdur.",
      en: "There is no such data.",
      ru: "Таких данных нет.",
    });
  } else {
    user.name = req.body.name;
    user.surname = req.body.surname;
    user.password = req.body.password;
    user.phone = req.body.phone;
    user.gender = req.body.gender;
    await user.save();
    res.status(200).json(user);
  }
};

exports.userDel = async (req, res) => {
  const user = await User.findByIdAndDelete(req.params.id);
  if (!user) {
    return res.status(404).json({
      az: "Belə bir məlumat yoxdur.",
      en: "There is no such data.",
      ru: "Таких данных нет.",
    });
  } else {
    res.status(200).json(user);
  }
};
