const { registerValidate, loginValidate } = require('../../models/auth/auth');
const { Wishlist } = require('../../models/auth/wishlist.js');
const { User } = require('../../models/auth/user');
const bcrypt = require('bcrypt');
const jwt = require('jsonwebtoken');

exports.register = async (req, res) => {
  const { error } = registerValidate(req.body);
  if (error) {
    res.status(400).send(error.message);
  } else {
    let user = await User.findOne({ email: req.body.email });
    if (user) {
      return res.status(401).json({
        az: 'Bu istifadəçi artıq mövcuddur.',
        en: 'This user already exists.',
        ru: 'Этот пользователь уже существует.',
      });
    } else {
      const hashPassword = await bcrypt.hash(req.body.password, 10);
      user = new User(req.body);
      user.password = hashPassword;
      user.createAuthToken();
      await user.save();

      const wishlist = new Wishlist({ user: user._id, items: [] });
      await wishlist.save();

      res.status(200).json({
        az: 'Siz uğurla qeydiyyatdan keçdiniz.',
        en: 'You have successfully registered.',
        ru: 'Вы успешно зарегистрировались.',
        user: {
          id: user.id,
          name: user.name,
          surname: user.surname,
          phone: user.phone,
          email: user.email,
          gender: user.gender,
        },
      });
    }
  }
};

exports.login = async (req, res) => {
  const { error } = loginValidate(req.body);

  if (error) {
    return res.status(400).send(error.message);
  }

  let user = await User.findOne({ email: req.body.email });
  if (!user) {
    return res.status(400).json({
      az: 'Belə bir istifadəçi mövcud deyil.',
      en: 'Such user does not exist.',
      ru: 'Такого пользователя не существует.',
    });
  } else {
    const isSuccess = await bcrypt.compare(req.body.password, user.password);
    if (!isSuccess) {
      return res.status(400).json({
        az: 'Email və ya şifrə yanlışdır!',
        en: 'Email or password is wrong!',
        ru: 'Электронная почта или пароль неверны!',
      });
    } else {
      const token = user.createAuthToken();
      res.status(200).json({
        message: {
          az: 'Hesabınıza uğurla daxil oldunuz.',
          en: 'You have successfully been added to your account.',
          ru: 'Вы успешно добавлены в свою учетную запись.',
        },
        data: {
          id: user.id,
          name: user.name,
          surname: user.surname,
          phone: user.phone,
          email: user.email,
          gender: user.gender,
          token: token,
        },
      });
    }
  }
};

exports.logout = async (req, res) => {
  try {
    const token = req.header('ekorpem-auth-token');
    if (!token) {
      return res.status(401).json({
        az: 'Sizin səlahiyyətiniz yoxdur!',
        en: 'You do not have authority!',
        ru: 'У вас нет полномочий!',
      });
    }

    const decodedToken = jwt.verify(token, 'jwtPrivateKey');

    res.clearCookie('ekorpem-auth-token');
    res.status(200).json({
      az: 'Uğurla çıxış etdiniz.',
      en: 'You have successfully logged out.',
      ru: 'Вы успешно вышли из системы.',
    });
  } catch (ex) {
    console.error(ex);
    res.status(400).json({
      az: 'Yanlış token!',
      en: 'Wrong token!',
      ru: 'Неверный токен!',
    });
  }
};

exports.resetPassword = async (req, res) => {
  const { email } = req.body;
  const oldUser = await User.findOne({ email });
  if (!oldUser) {
    return res.status(404).send('User not exists!');
  } else {
    const token = jwt.sign(
      { email: oldUser.email, id: oldUser._id },
      'PrivateKey',
      { expiresIn: '5m' }
    );
    const link = `http://localhost:3005/reset-password/${oldUser._id}/${token}`;
    res.status(200).send(link);
  }
};
