const { About, aboutValidate } = require('../models/about');
const { deleteSingleOldImage } = require('../utils/deleteOldImage');

exports.aboutList = async (req, res) => {
  const about = await About.find();
  res.status(200).json(about);
};

exports.aboutAdd = async (req, res) => {
  const { error } = aboutValidate(req.body);
  let result;
  let about;
  if (error) {
    res.status(400).send(error.message);
  } else {
    about = new About(req.body);
    if (!req.file) {
      result = await about.save();
      res.status(201).json({
        message: {
          az: 'Məlumat uğurla əlavə edildi.',
          en: 'Information added successfully.',
          ru: 'Информация успешно добавлена.',
        },
        data: result,
      });
    } else {
      about.image = req.file.path;
      result = await about.save();
      res.status(201).json({
        message: {
          az: 'Məlumat uğurla əlavə edildi.',
          en: 'Information added successfully.',
          ru: 'Информация успешно добавлена.',
        },
        data: result,
      });
    }
  }
};

exports.aboutEdit = async (req, res) => {
  const { error } = aboutValidate(req.body);
  if (error) {
    res.status(400).send(error.message);
  } else {
    if (!req.file) {
      const about = await About.findByIdAndUpdate('6846120ea1a885bc48ca2b92', {
        ...req.body,
      });
      await about.save();
      res.status(200).json({
        message: {
          az: 'Məlumat uğurla yeniləndi.',
          en: 'Information updated successfully.',
          ru: 'Информация успешно обновлена.',
        },
        data: about,
      });
    } else {
      const about = await About.findByIdAndUpdate('6846120ea1a885bc48ca2b92', {
        ...req.body,
      });
      const oldImages = about.image;
      deleteSingleOldImage(oldImages);
      about.image = req.file.path;
      await about.save();
      res.status(200).json({
        message: {
          az: 'Məlumat uğurla yeniləndi.',
          en: 'Information updated successfully.',
          ru: 'Информация успешно обновлена.',
        },
        data: about,
      });
    }
  }
};

// ============================ about end ===============================
